function [RABT,tmapav]    =   RABT_TmapUndistort(RABT,tmap_folder,folder)
% RABT_TmapUndistort
% 
% Author: Koen Hilgersom (2011)
% 01/07/2011
%
% Function file is run by the script 'Rising Air Bubble Technique_vX_X.m'
%
% This function reads the metadata using the executive 'exiftool.exe' by Phil
% Harvey (http://www.sno.phy.queensu.ca/~phil/exiftool/). Make sure this
% tool is installed in the same folder as the m-files. In case an updated
% version is downloaded, make sure that it gets the same name
% ('exiftool.exe').
%
% Based on the metadata the function determines whether a new
% transformation matrix should be created to undistort the picture (based
% on camera name, lens and focal length).
%
% Input
% RABT          -    RABT variables
% tmap_folder   -    Folder name of the transformation matrices folder
% folder        -    Folder name of the picture folder
% 
% Output
% RABT          -    RABT variables including the names of the camera and the lens as well as the focal length
% tmapav        -    Is there already a transformation matrix for the given camera, lens and focal length?
%
%---------------------------------------------------------------------------  
%      Copyright (C) 2011 Technische Universiteit Delft, 
%          Koen Hilgersom
%          K.P.Hilgersom@tudelft.nl (correspondence)
% 
%---------------------------------------------------------------------------  

%% load picture metadata
[~, imdata] = dos(['exiftool "' folder '/1 pics/DSC_' RABT.nr '.JPG"']);
newlines=find(uint8(imdata)==10);
lines=cat(2,[0;newlines(1:end-1)']+ones(length(newlines),1),newlines'-ones(length(newlines),1));
imdata2=[];
for n=1:length(lines)
    imdata2=char(imdata2,imdata(lines(n,1):lines(n,2)));
end

% camera name
loc_cn = strncmp('Camera Model Name',cellstr(imdata2),17);
loc_cn2= strfind(imdata2(loc_cn,:),':')+2;
RABT.cn=deblank(imdata2(loc_cn,loc_cn2:end));
disp(['Camera: ' RABT.cn])

% lens name
loc_ln = strncmp('Lens ID',cellstr(imdata2),7);
loc_ln2 = logical(loc_ln-strncmp('Lens ID Number',cellstr(imdata2),14));
loc_ln3= strfind(imdata2(loc_ln2,:),':')+2;
RABT.ln=deblank(imdata2(loc_ln2,loc_ln3:end));
RABT.ln2=regexprep(RABT.ln,cellstr(['/';'\';'?';':';'"';'*';'<';'>';'|']),'_');
disp(['Lens: ' RABT.ln])

% focal length
loc_fl=find(strncmp('Focal Length',cellstr(imdata2),12)==1);
loc_fl2=zeros(length(loc_fl),1);
for n=1:length(loc_fl)
    loc_fl2(n)=sum(isspace(imdata2(loc_fl(n),:)));
end
[~,loc_fl3] = max(loc_fl2);
isdigit=find(isstrprop(imdata2(loc_fl(loc_fl3),:),'digit')==1);
RABT.fl=str2double(imdata2(loc_fl(loc_fl3),isdigit(1):isdigit(end)));
disp(['Focal length: ' num2str(RABT.fl) ' mm'])
        
%% availability of transformation matrix for this camera, lens and focal length

% is there a saved version of the transformation matrix for this camera, lens and focal length?
tmapav = exist([tmap_folder '\' RABT.cn '\' RABT.ln2 '\' num2str(RABT.fl) 'mm_' RABT.orientation '.mat'],'file');

if tmapav ==0 % no transformation matrix was found
    
    % create folder structure to save transformation matrix (once a camera
    %   or lens is not used anymore, you might want to delete this folder again)
    if exist([tmap_folder '\' RABT.cn],'dir')==0
        mkdir(tmap_folder, RABT.cn);
    end
    if exist([tmap_folder '\' RABT.cn '\' RABT.ln2],'dir')==0
        mkdir([tmap_folder '\' RABT.cn], RABT.ln2);
    end

end

